export declare const CPlaceholder: import("vue").DefineComponent<{
    /**
     * Set animation type to better convey the perception of something being actively loaded.
     *
     * @values 'glow', 'wave'
     */
    animation: {
        type: StringConstructor;
        default: undefined;
        require: boolean;
        validator: (value: string) => boolean;
    };
    /**
     * Sets the color context of the component to one of CoreUI’s themed colors.
     *
     * @values 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark', 'light'
     */
    color: {
        type: StringConstructor;
        validator: (value: string) => boolean;
    };
    /**
     * Component used for the root node. Either a string to use a HTML element or a component.
     */
    component: {
        type: StringConstructor;
        default: string;
        required: false;
    };
    /**
     * Size the component extra small, small, or large.
     *
     * @values 'xs', 'sm', 'lg'
     */
    size: {
        type: StringConstructor;
        default: undefined;
        required: false;
        validator: (value: string) => boolean;
    };
    /**
     * The number of columns on extra small devices (<576px).
     */
    xs: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on small devices (<768px).
     */
    sm: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on medium devices (<992px).
     */
    md: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on large devices (<1200px).
     */
    lg: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on X-Large devices (<1400px).
     */
    xl: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on XX-Large devices (≥1400px).
     */
    xxl: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
}, () => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * Set animation type to better convey the perception of something being actively loaded.
     *
     * @values 'glow', 'wave'
     */
    animation: {
        type: StringConstructor;
        default: undefined;
        require: boolean;
        validator: (value: string) => boolean;
    };
    /**
     * Sets the color context of the component to one of CoreUI’s themed colors.
     *
     * @values 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark', 'light'
     */
    color: {
        type: StringConstructor;
        validator: (value: string) => boolean;
    };
    /**
     * Component used for the root node. Either a string to use a HTML element or a component.
     */
    component: {
        type: StringConstructor;
        default: string;
        required: false;
    };
    /**
     * Size the component extra small, small, or large.
     *
     * @values 'xs', 'sm', 'lg'
     */
    size: {
        type: StringConstructor;
        default: undefined;
        required: false;
        validator: (value: string) => boolean;
    };
    /**
     * The number of columns on extra small devices (<576px).
     */
    xs: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on small devices (<768px).
     */
    sm: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on medium devices (<992px).
     */
    md: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on large devices (<1200px).
     */
    lg: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on X-Large devices (<1400px).
     */
    xl: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
    /**
     * The number of columns on XX-Large devices (≥1400px).
     */
    xxl: {
        type: NumberConstructor;
        default: undefined;
        require: boolean;
    };
}>>, {
    component: string;
    size: string;
    sm: number;
    md: number;
    lg: number;
    xl: number;
    xs: number;
    xxl: number;
    animation: string;
}>;
