import { PropType } from 'vue';
export interface Column {
    label?: string;
    key: string;
    _style?: any;
    _props?: any;
}
export interface FooterItem {
    label?: string;
    _props?: any;
}
export type Item = {
    [key: string]: number | string | any;
    _props?: any;
};
declare const CTable: import("vue").DefineComponent<{
    /**
     * Set the vertical aligment.
     *
     * @values 'bottom', 'middle', 'top'
     */
    align: {
        type: StringConstructor;
        default: undefined;
        required: false;
        validator: (value: string) => boolean;
    };
    /**
     * Sets the border color of the component to one of CoreUI’s themed colors.
     *
     * @values 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark', 'light'
     */
    borderColor: {
        type: StringConstructor;
        validator: (value: string) => boolean;
    };
    /**
     * Add borders on all sides of the table and cells.
     */
    bordered: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Remove borders on all sides of the table and cells.
     */
    borderless: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Put the `<caption>` on the top of the table.
     *
     * @values 'top' | string
     */
    caption: {
        type: StringConstructor;
        default: undefined;
        required: false;
    };
    /**
     * Set the text of the table caption and the caption on the top of the table.
     *
     * @since 4.5.0
     */
    captionTop: {
        type: StringConstructor;
        default: undefined;
        required: false;
    };
    /**
     * Prop for table columns configuration. If prop is not defined, table will display columns based on the first item keys, omitting keys that begins with underscore (e.g. '_props')
     *
     * In columns prop each array item represents one column. Item might be specified in two ways:
     * String: each item define column name equal to item value.
     * Object: item is object with following keys available as column configuration:
     * - key (required)(String) - define column name equal to item key.
     * - label (String) - define visible label of column. If not defined, label will be generated automatically based on column name, by converting kebab-case and snake_case to individual words and capitalization of each word.
     * - _props (Object) - adds classes to all cels in column, ex. _props: { scope: 'col', className: 'custom-class' },
     * - _style (Object) - adds styles to the column header (useful for defining widths)
     *
     * @since 4.5.0
     */
    columns: {
        type: PropType<(string | Column)[]>;
        required: false;
    };
    /**
     * Sets the color context of the component to one of CoreUI’s themed colors.
     *
     * @values  'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark', 'light', string
     */
    color: {
        type: StringConstructor;
        validator: (value: string) => boolean;
    };
    /**
     * Array of objects or strings, where each element represents one cell in the table footer.
     *
     * Example items:
     * ['FooterCell', 'FooterCell', 'FooterCell']
     * or
     * [{ label: 'FooterCell', _props: { color: 'success' }, ...]
     *
     * @since 4.5.0
     */
    footer: {
        type: PropType<(string | FooterItem)[]>;
        required: false;
    };
    /**
     * Enable a hover state on table rows within a `<CTableBody>`.
     */
    hover: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Array of objects, where each object represents one item - row in table. Additionally, you can add style classes to each row by passing them by '_props' key and to single cell by '_cellProps'.
     *
     * Example item:
     * { name: 'John' , age: 12, _props: { color: 'success' }, _cellProps: { age: { className: 'fw-bold'}}}
     *
     * @since 4.5.0
     */
    items: {
        type: PropType<Item[]>;
        required: false;
    };
    responsive: {
        type: (StringConstructor | BooleanConstructor)[];
        default: undefined;
        required: false;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Make table more compact by cutting all cell `padding` in half.
     */
    small: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Add zebra-striping to any table row within the `<CTableBody>`.
     */
    striped: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Add zebra-striping to any table column.
     *
     * @since 4.4.0
     */
    stripedColumns: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Properties that will be passed to the table footer component.
     *
     * Properties to [CTableFoot](#ctablefoot) component.
     * @since 4.5.0
     */
    tableFootProps: {
        type: ObjectConstructor;
        default: undefined;
        required: false;
    };
    /**
     * Properties that will be passed to the table head component.
     *
     *  Properties to [CTableHead](#ctablehead) component.
     * @since 4.5.0
     */
    tableHeadProps: {
        type: ObjectConstructor;
        default: undefined;
        required: false;
    };
}, () => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}>[], unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * Set the vertical aligment.
     *
     * @values 'bottom', 'middle', 'top'
     */
    align: {
        type: StringConstructor;
        default: undefined;
        required: false;
        validator: (value: string) => boolean;
    };
    /**
     * Sets the border color of the component to one of CoreUI’s themed colors.
     *
     * @values 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark', 'light'
     */
    borderColor: {
        type: StringConstructor;
        validator: (value: string) => boolean;
    };
    /**
     * Add borders on all sides of the table and cells.
     */
    bordered: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Remove borders on all sides of the table and cells.
     */
    borderless: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Put the `<caption>` on the top of the table.
     *
     * @values 'top' | string
     */
    caption: {
        type: StringConstructor;
        default: undefined;
        required: false;
    };
    /**
     * Set the text of the table caption and the caption on the top of the table.
     *
     * @since 4.5.0
     */
    captionTop: {
        type: StringConstructor;
        default: undefined;
        required: false;
    };
    /**
     * Prop for table columns configuration. If prop is not defined, table will display columns based on the first item keys, omitting keys that begins with underscore (e.g. '_props')
     *
     * In columns prop each array item represents one column. Item might be specified in two ways:
     * String: each item define column name equal to item value.
     * Object: item is object with following keys available as column configuration:
     * - key (required)(String) - define column name equal to item key.
     * - label (String) - define visible label of column. If not defined, label will be generated automatically based on column name, by converting kebab-case and snake_case to individual words and capitalization of each word.
     * - _props (Object) - adds classes to all cels in column, ex. _props: { scope: 'col', className: 'custom-class' },
     * - _style (Object) - adds styles to the column header (useful for defining widths)
     *
     * @since 4.5.0
     */
    columns: {
        type: PropType<(string | Column)[]>;
        required: false;
    };
    /**
     * Sets the color context of the component to one of CoreUI’s themed colors.
     *
     * @values  'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark', 'light', string
     */
    color: {
        type: StringConstructor;
        validator: (value: string) => boolean;
    };
    /**
     * Array of objects or strings, where each element represents one cell in the table footer.
     *
     * Example items:
     * ['FooterCell', 'FooterCell', 'FooterCell']
     * or
     * [{ label: 'FooterCell', _props: { color: 'success' }, ...]
     *
     * @since 4.5.0
     */
    footer: {
        type: PropType<(string | FooterItem)[]>;
        required: false;
    };
    /**
     * Enable a hover state on table rows within a `<CTableBody>`.
     */
    hover: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Array of objects, where each object represents one item - row in table. Additionally, you can add style classes to each row by passing them by '_props' key and to single cell by '_cellProps'.
     *
     * Example item:
     * { name: 'John' , age: 12, _props: { color: 'success' }, _cellProps: { age: { className: 'fw-bold'}}}
     *
     * @since 4.5.0
     */
    items: {
        type: PropType<Item[]>;
        required: false;
    };
    responsive: {
        type: (StringConstructor | BooleanConstructor)[];
        default: undefined;
        required: false;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Make table more compact by cutting all cell `padding` in half.
     */
    small: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Add zebra-striping to any table row within the `<CTableBody>`.
     */
    striped: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Add zebra-striping to any table column.
     *
     * @since 4.4.0
     */
    stripedColumns: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Properties that will be passed to the table footer component.
     *
     * Properties to [CTableFoot](#ctablefoot) component.
     * @since 4.5.0
     */
    tableFootProps: {
        type: ObjectConstructor;
        default: undefined;
        required: false;
    };
    /**
     * Properties that will be passed to the table head component.
     *
     *  Properties to [CTableHead](#ctablehead) component.
     * @since 4.5.0
     */
    tableHeadProps: {
        type: ObjectConstructor;
        default: undefined;
        required: false;
    };
}>>, {
    small: boolean;
    hover: boolean;
    align: string;
    responsive: string | boolean;
    striped: boolean;
    caption: string;
    bordered: boolean;
    borderless: boolean;
    captionTop: string;
    stripedColumns: boolean;
    tableFootProps: Record<string, any>;
    tableHeadProps: Record<string, any>;
}>;
export { CTable };
