@php
    $media_path = getFilePath($details->id);
    if ($details->file_type == 'pdf') {
        $media_path = project_asset('/backend/assets/img/pdf-placeholder.png');
    } elseif ($details->file_type == 'zip') {
        $media_path = project_asset('/backend/assets/img/zip-placeholder.png');
    } elseif ($details->file_type == 'mp4' || $details->file_type == 'video') {
        $media_path = project_asset('/backend/assets/img/mp4-placeholder.png');
    }
@endphp
<div class="thumbnail preview-image">
    <img id='preview_image' class="media_preview_image" src="{{ $media_path }}" alt="{{ $details->name }}" />
</div>
<div class="attachment-meta-wrap mt-30 mt-md-0">
    <div class="details mb-3 pb-3 border-bottom2">
        <div class="word-break">
            <span class="font-weight-bolder">{{ translate('File Name:') }} </span>
            <span id="file_name">{{ $details->name }}</span>
        </div>
        <div class="word-break">
            <span class="font-weight-bolder">{{ translate('File URL:') }} </span>
            <input class="theme-input-style" id="file_url" type="text" value="{{ url($details->path) }}" readonly>
        </div>
        <div>
            <span class="font-weight-bolder">{{ translate('File Type:') }} </span>
            <span id="file_type" class="text-uppercase">{{ $details->file_type }}</span>
        </div>
        <div>
            <span class="font-weight-bolder">{{ translate('File Size:') }} </span>
            <span id="file_size">{{ $details->size / 100 }} KB</span>
        </div>
        <div>
            <span class="font-weight-bolder">{{ translate('Uploaded By:') }} </span>
            <span id="uploaded_by">{{ $details->uploaded_by }}</span>
        </div>
        <div>
            <span class="font-weight-bolder">{{ translate('Created At:') }} </span>
            <span id="creaated_at">{{ $details->created_at }}</span>
        </div>
        <div>
            <span class="font-weight-bolder">{{ translate('Updated At:') }} </span>
            <span id="updated_at">{{ $details->updated_at }}</span>
        </div>
        <div class="d-flex gap-10 justify-content-end flex-wrap mt-2">
            <a type="button" id="download_file" target="_blank" href="{{ url($details->path) }}" class="btn sm "
                data-clipboard-target="#attachment-details-copy-link">
                {{ translate('Download') }}
            </a>
            <button type="button" class="btn sm" id="copy-link-btn">
                {{ translate('Copy URL to clipboard') }}
            </button>
        </div>
    </div>
    <form>
        <input type="hidden" name="id" id="media_id" value="{{ $details->id }}">
        <div class="settings-wrap pb-3 mb-3 border-bottom2">
            <span class="setting mb-10 has-description">
                <label for="attachment-details-alt-text" class="name">{{ translate('Alt Text') }}</label>
                <input type="text" id="attachment-details-alt-text" name="alt" value="{{ $details->alt }}"
                    class="theme-input-style" />
                <div class="invalid-input" id="alt_update_error"></div>
            </span>
            <span class="setting mb-10">
                <label for="attachment-details-title" class="name">{{ translate('Title') }}</label>
                <input type="text" id="attachment-details-title" name="title" value="{{ $details->title }}"
                    class="theme-input-style" />
                <div class="invalid-input" id="title_update_error"></div>
            </span>
            <span class="setting mb-10">
                <label for="attachment-details-caption" class="name">{{ translate('Caption') }}</label>
                <textarea id="attachment-details-caption" name='caption' class="theme-input-style">{{ $details->caption }}</textarea>
                <div class="invalid-input" id="caption_update_error"></div>
            </span>
            <span class="setting mb-10">
                <label for="attachment-details-description" class="name">{{ translate('Description') }}</label>
                <textarea id="attachment-details-description" name="description" class="theme-input-style">{{ $details->description }}</textarea>
                <div class="invalid-input" id="description_update_error"></div>
            </span>
        </div>
        <div class="d-flex gap-10 justify-content-end flex-wrap mt-2">
            <button type="button" class="btn sm copy-attachment-url"
                data-clipboard-target="#attachment-details-copy-link" onclick="updateMedia()">
                {{ translate('Save') }}
            </button>
            <button type="button" class="btn sm copy-attachment-url btn-danger"
                data-clipboard-target="#attachment-details-copy-link" onclick="deleteMediaFile()">
                {{ translate('Delete Permanently') }}
            </button>
        </div>
    </form>
</div>
