import { RendererElement } from 'vue';
declare const COffcanvas: import("vue").DefineComponent<{
    /**
     * Apply a backdrop on body while offcanvas is open.
     *
     * @values boolean | 'static'
     */
    backdrop: {
        type: (StringConstructor | BooleanConstructor)[];
        default: boolean;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Closes the offcanvas when escape key is pressed.
     */
    keyboard: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Components placement, there’s no default placement.
     *
     * @values 'start', 'end', 'top', 'bottom'
     */
    placement: {
        type: StringConstructor;
        default: undefined;
        require: boolean;
        validator: (value: string) => boolean;
    };
    /**
     * Responsive offcanvas property hide content outside the viewport from a specified breakpoint and down.
     *
     * @values boolean | 'sm' | 'md' | 'lg' | 'xl' | 'xxl'
     * @since 4.7.0
     */
    responsive: {
        type: (StringConstructor | BooleanConstructor)[];
        default: boolean;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Allow body scrolling while offcanvas is open
     */
    scroll: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Toggle the visibility of offcanvas component.
     */
    visible: BooleanConstructor;
}, () => (false | "" | import("vue").VNode<import("vue").RendererNode, RendererElement, {
    [key: string]: any;
}>)[], unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("hide" | "show")[], "hide" | "show", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * Apply a backdrop on body while offcanvas is open.
     *
     * @values boolean | 'static'
     */
    backdrop: {
        type: (StringConstructor | BooleanConstructor)[];
        default: boolean;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Closes the offcanvas when escape key is pressed.
     */
    keyboard: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Components placement, there’s no default placement.
     *
     * @values 'start', 'end', 'top', 'bottom'
     */
    placement: {
        type: StringConstructor;
        default: undefined;
        require: boolean;
        validator: (value: string) => boolean;
    };
    /**
     * Responsive offcanvas property hide content outside the viewport from a specified breakpoint and down.
     *
     * @values boolean | 'sm' | 'md' | 'lg' | 'xl' | 'xxl'
     * @since 4.7.0
     */
    responsive: {
        type: (StringConstructor | BooleanConstructor)[];
        default: boolean;
        validator: (value: boolean | string) => boolean;
    };
    /**
     * Allow body scrolling while offcanvas is open
     */
    scroll: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * Toggle the visibility of offcanvas component.
     */
    visible: BooleanConstructor;
}>> & {
    onHide?: ((...args: any[]) => any) | undefined;
    onShow?: ((...args: any[]) => any) | undefined;
}, {
    scroll: boolean;
    visible: boolean;
    placement: string;
    backdrop: string | boolean;
    keyboard: boolean;
    responsive: string | boolean;
}>;
export { COffcanvas };
